package music;

import java.util.LinkedList;

public class Playlist {
	
	private LinkedList<Song> songs;
//	private LinkedList<Song> songs = new LinkedList<Song>();

	public Playlist(LinkedList<Song> songs) {
		super();
		this.songs = songs;
	}

	public Playlist() {
		songs = new LinkedList<Song>();
	}
	
	public void addSong(Song song) {
		if (song != null) {
			songs.add(song);
		}
	}
	
	public boolean removeSong(Song song) {
		return songs.remove(song);
	}
	
	public void playAll() throws EmptyPlaylistException {
		if (songs.size() != 0) {
			for (int i = 0; i < songs.size(); i++) {
				songs.get(i).display();
			} 
		} else {
			throw new EmptyPlaylistException();
		}
	}

	public LinkedList<Song> getSongs() {
		return songs;
	}

	public void setSongs(LinkedList<Song> songs) {
		this.songs = songs;
	}

}
